namespace takmicenje
{
    class Trkac
    {
        #region atributi
        int x, y;
        int smer;
        bool ok;
        #endregion
        #region konstruktori
        public Trkac()
        {
            x = y = 0;
            smer = 'x';
            ok = false;
        }
        public Trkac(int x, int y, int smer)
        {
            this.x = x;
            this.y = y;
            this.smer = smer;
            ok = true;
        }
        public Trkac(string str, int smer)
        {
            string[] s = str.Split();
            x = int.Parse(s[0]);
            y = int.Parse(s[1]);
            this.smer = smer;
            ok = true;
        }
        #endregion
        #region svojstva
        public int X
        {
            get { return x; }
            set { x = value; }
        }
        public int Y
        {
            get { return y; }
            set { y = value; }
        }
        public int Smer
        { get { return smer; } }
        public bool Krece
        {
            get { return ok; }
            set { ok = value; }
        }
        public string Prikaz
        {
            get { return "(" + this.X + "," + this.Y + ") "; }
        }
        #endregion
        #region metode
        public Trkac trci()
        {
            if (smer == 0) return new Trkac(this.X + 1, y, smer);
            if (smer == 1) return new Trkac(this.X - 1, y, smer);
            if (smer == 2) return new Trkac(x, this.Y + 1, smer);
            if (smer == 3) return new Trkac(x, this.Y - 1, smer);
            return new Trkac();
        }
        public bool Ugranicama(int[] g)
        {
            return (x >= g[0]) && (x <= g[1]) && (y <= g[2]) && (y >= g[3]);
        }
        #endregion
        #region operatori
        static public bool operator -(Trkac A, Trkac B)
        {
            return (A.X == B.X && A.Y == B.Y);
        }
        #endregion
    }

        internal class Program
    {
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Trkac[] t = new Trkac[n * 4];
            int[] granice = new int[4];
            string s = Console.ReadLine();
            for (int j = 0; j < 4; j++)
                t[j] = new Trkac(s, j);
            granice[0] = t[0].X;
            granice[1] = t[0].X;
            granice[2] = t[0].Y;
            granice[3] = t[0].Y;
            for (int i = 4; i < n * 4; i = i + 4)
            {
                s = Console.ReadLine();
                for (int j = 0; j < 4; j++)
                {
                    t[i + j] = new Trkac(s, j);
                    if (t[i + j].X < granice[0]) granice[0] = t[i + j].X;
                    if (t[i + j].X > granice[1]) granice[1] = t[i + j].X;
                    if (t[i + j].Y > granice[2]) granice[2] = t[i + j].Y;
                    if (t[i + j].Y < granice[3]) granice[3] = t[i + j].Y;
                }
            }
            n = n * 4;
            int br = 0;
            while (da(t, n, granice))
            {
                pokret(t, n, granice);
                for (int i = 0; i < n; i++)
                    for (int j = i + 1; j < n; j++)
                        if (t[i] - t[j])
                        {
                            br++;
                        }
            }
            Console.WriteLine(br);
        }

        static bool da(Trkac[] t, int n, int[] g)
        {
            for (int i = 0; i < n; i++)
                if (t[i].Ugranicama(g)) 
                    return true;
            return false;
        }

        static void pokret(Trkac[] t, int n, int[] g)
        {
            for (int i = 0; i < n; i++)
            {
                t[i] = t[i].trci();
                //t[i].Krece = t[i].Ugranicama(g);
            }
        }
    }
}